<?php

/**************************************************************
 * CGI's  MailForm ver2.0x
 * E-Mail:info@cgis.biz
 * HomePage:https://www.cgis.biz/
 * (C) CGI's 2025/12/31
 * 
 * ・PHP8.3.29で動作確認しています。
 * ・著作権表示部とCGI'sへのリンク表示部は変更しないでください。
 * 
 **************************************************************/

// 定数定義
define('CONF_FILE', __DIR__ . '/conf/conf.php');
define('TITLE', 'MailForm管理画面');

// 共通変数/関数読込み
include_once __DIR__ . '/inc.php';
include_once __DIR__ . '/forms.php';

// フォーム定義
$formAdmin = array(
    'md' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '操作モード',
        'required' => false,
    ),
    'err' => array(
        'type' => VAR_TYPE_INT,
        'name' => 'エラーフラグ',
        'required' => false,
    ),
    'pass' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '管理者パスワード',
        'required' => true,
        'min' => 4,
        'max' => 12,
        'regexp' => PTN_PASS,
    ),
    'title' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'メールフォームタイトル',
        'required' => true,
    ),
    'admin' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '管理者メールアドレス',
        'required' => true,
        'regexp' => PTN_MAIL,
    ),
    'bcc' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'BCCメールアドレス',
        'required' => false,
        'regexp' => PTN_MAIL,
    ),
    'user_send' => array(
        'type' => VAR_TYPE_INT,
        'name' => 'ユーザーへ送信',
        'required' => false,
    ),
    'j_from' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '管理者メールアドレス（名前）',
        'required' => false,
    ),
    'home' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'HOME',
        'required' => false,
        'regexp' => PTN_URL,
    ),
    'need_name' => array(
        'type' => VAR_TYPE_INT,
        'name' => '必須項目(お名前)',
        'required' => false,
    ),
    'need_mail' => array(
        'type' => VAR_TYPE_INT,
        'name' => '必須項目(メールアドレス)',
        'required' => false,
    ),
    'need_subject' => array(
        'type' => VAR_TYPE_INT,
        'name' => '必須項目(件名)',
        'required' => false,
    ),
    'need_body' => array(
        'type' => VAR_TYPE_INT,
        'name' => '必須項目(本文)',
        'required' => false,
    ),
    'comment_input' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '入力画面のコメント',
        'required' => false,
    ),
    'comment_confirm' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '確認画面のコメント',
        'required' => false,
    ),
    'comment_send' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '送信完了画面のコメント',
        'required' => false,
    ),
    'bgcolor_body' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '全体の背景色',
        'required' => true,
        'regexp' => PTN_COLOR,
    ),
    'font_color' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '全体のフォントカラー',
        'required' => true,
        'regexp' => PTN_COLOR,
    ),
    'font_size' => array(
        'type' => VAR_TYPE_INT,
        'name' => '全体のフォントサイズ',
        'required' => true,
    ),
    'font_size_title' => array(
        'type' => VAR_TYPE_INT,
        'name' => 'タイトルのフォントサイズ',
        'required' => true,
    ),
    'place' => array(
        'type' => VAR_TYPE_INT,
        'name' => 'フォームの表示位置',
        'required' => true,
    ),
    'width' => array(
        'type' => VAR_TYPE_INT,
        'name' => 'フォームの幅',
        'required' => true,
    ),
    'border_form' => array(
        'type' => VAR_TYPE_STRING,
        'name' => 'フォームの枠線色',
        'required' => true,
        'regexp' => PTN_COLOR,
    ),
    'bgcolor_th' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '項目の背景色',
        'required' => true,
        'regexp' => PTN_COLOR,
    ),
    'bgcolor_td' => array(
        'type' => VAR_TYPE_STRING,
        'name' => '入力欄の背景色',
        'required' => true,
        'regexp' => PTN_COLOR,
    ),
);

// 共通処理
commonProc();

// フォーム値セット
$forms = importForms($formAdmin);

// 設定読込み
$confs = LoadConf(CONF_FILE);

// 初期
$JS = '';
if (!$forms['md']['value']) {
    $contents = loginAction($forms['err']['value']);
}
// ログイン実行
elseif ($forms['md']['value'] == 'loginExec') {
    $contents = loginExecAction($forms, $confs);
}
// 編集
elseif ($forms['md']['value'] == 'edit') {
    loginCheck($confs);
    $JS = jsAdmin();
    $contents = editAction($forms, $confs);
}
// 編集実行
elseif ($forms['md']['value'] == 'editExec') {
    loginCheck($confs);
    $contents = editExecAction($forms, $confs);
}
// ログアウト
elseif ($forms['md']['value'] == 'logout') {
    $contents = logoutAction($forms);
}

// 画面表示
$html = htmlHeader(TITLE, cssAdmin(), $JS);
$html .= '<div class="contents">'."\n";
$html .= '<h1>'.TITLE.'</h1>'."\n";
$html .= '<p class="right"><a href="mail.php">メールフォーム</a> | <a href="admin.php?md=logout">ログアウト</a></p>'."\n";
$html .= '<br>'."\n";
$html .= $contents;
$html .= '</div>'."\n";
$html .= htmlFooter();

echo $html;

exit;


// ================================================================================

/**
*
* 初期
*
*/
function loginAction($err = 0)
{
    $html = '<div class="center">'."\n";
    if ($err == 1) {
        $html .= '<p class="attention">パスワードが間違っています。</p>'."\n";
    } elseif ($err == 2) {
        $html .= '<p class="attention">パスワードが間違っているか、ログインセッションが無効となりました。</p>'."\n";
    }
    $html .= '<form method="post" action="admin.php">'."\n";
    $html .= '<input type="password" name="pass" value="">'."\n";
    $html .= '<input type="submit" value="ログイン">'."\n";
    $html .= '<input type="hidden" name="md" value="loginExec">'."\n";
    $html .= '</form>'."\n";
    $html .= '</div>'."\n";
    return $html;
}
/**
*
* ログイン
*
*/
function loginExecAction($forms, $confs)
{
    if ($forms['pass']['value'] === $confs['pass']) {
        $_SESSION['pass'] = $forms['pass']['value'];
        header('Location: admin.php?md=edit');
    } else {
        header('Location: admin.php?err=1');
    }
    return 'Error: Location Error';
}
/**
*
* ログインチェック
*
*/
function loginCheck($confs)
{
    if ($_SESSION['pass'] !== $confs['pass']) {
        header('Location: admin.php?err=2');
    }
}
/**
*
* 編集
*
*/
function editAction($forms, $confs)
{
    $chk = array('0' => '','1' => ' checked');

    $html = '';
    if (SAMPLE == true) {
        $html .= '<p class="attention">サンプルにつき設定変更はできません。</p>'."\n";
    }
    $html .= '<p>※は入力必須となります。</p>'."\n";
    $html .= '<form method="post" action="admin.php" name="AdminForm">'."\n";
    $html .= '<div class="admin_t">'."\n";
    $html .= '<table>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th colspan="2"><div class="center">基本的な項目</div></th>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>※'.$forms['pass']['name'].'</th>'."\n";
    $html .= '<td><input type="password" name="pass" value="'.showEscap($confs['pass']).'"><br><span class="small">本画面アクセスパスワード。半角英数字4～12文字</span></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$forms['title']['name'].'</th>'."\n";
    $html .= '<td><input type="text" name="title" value="'.showEscap($confs['title']).'"><br><span class="small">メールフォーム上部に表示されます。</span></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>※'.$forms['admin']['name'].'</th>'."\n";
    $html .= '<td><input type="text" name="admin" value="'.showEscap($confs['admin']).'" size="50" class="imeoff"><br><span class="small">このアドレスに投稿内容が送信されます。</span></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$forms['bcc']['name'].'</th>'."\n";
    $html .= '<td><input type="text" name="bcc" value="'.showEscap($confs['bcc']).'" size="50" class="imeoff"><br><span class="small">設定した場合、写しが送信されます。</span></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$forms['user_send']['name'].'</th>'."\n";
    $html .= '<td><input type="checkbox" name="user_send" value="1" id="user_send"'.$chk[($confs['user_send'])].'><label for="user_send"> 送信する</label><br><span class="small">チェックした場合、投稿者のメールアドレスへも送信します。</span></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$forms['j_from']['name'].'</th>'."\n";
    $html .= '<td><input type="text" name="j_from" value="'.showEscap($confs['j_from']).'"><br><span class="small">ユーザーへ送信をチェックしている場合、ユーザーへ送信するメールのFrom(管理者)アドレスの前に表示されます。</span></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$forms['home']['name'].'</th>'."\n";
    $html .= '<td><input type="text" name="home" value="'.showEscap($confs['home']).'" size="50" class="imeoff"><br><span class="small">メールフォーム右上に表示される「HOME」のリンクURL。未設定で非表示。</span></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>必須項目</th>'."\n";

    $html .= '<td>'."\n";
    $html .= '<input type="checkbox" name="need_name" value="1" id="need_name"'.$chk[($confs['need_name'])].'><label for="need_name"> お名前</label>'."\n";
    $html .= '<input type="checkbox" name="need_mail" value="1" id="need_mail"'.$chk[($confs['need_mail'])].'><label for="need_mail"> メールアドレス</label>'."\n";
    $html .= '<input type="checkbox" name="need_subject" value="1" id="need_subject"'.$chk[($confs['need_subject'])].'><label for="need_subject"> 件名</label>'."\n";
    $html .= '<input type="checkbox" name="need_body" value="1" id="need_body"'.$chk[($confs['need_body'])].'><label for="need_body"> 本文</label>'."\n";
    $html .= '<br><span class="small">メールフォーム各項目の必須設定。</span></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$forms['comment_input']['name'].'</th>'."\n";
    $html .= '<td><textarea name="comment_input" cols="40" rows="3">'.showEscap($confs['comment_input']).'</textarea></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$forms['comment_confirm']['name'].'</th>'."\n";
    $html .= '<td><textarea name="comment_confirm" cols="40" rows="3">'.showEscap($confs['comment_confirm']).'</textarea></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th>'.$forms['comment_send']['name'].'</th>'."\n";
    $html .= '<td><textarea name="comment_send" cols="40" rows="3">'.showEscap($confs['comment_send']).'</textarea></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<th colspan="2"><div class="center">デザインの設定</div></th>'."\n";
    $html .= '</tr>'."\n";
    if ($confs['place'] == 1) {
        $chk0 = '';
        $chk1 = ' checked';
    } else {
        $chk0 = ' checked';
        $chk1 = '';
    }

    $html .= '<tr>'."\n";
    $html .= '<th>※'.$forms['bgcolor_body']['name'].'</th>'."\n";
    $html .= '<td>'."\n";

    $html .= '<div class="border0">'."\n";
    $html .= '<table>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<td># <input type="text" name="bgcolor_body" value="'.showEscap($confs['bgcolor_body']).'" size="8" class="imeoff" onchange="ColorSet()"></td>'."\n";
    $html .= '<td><div id="sample_bgcolor_body" style="width:10px;height:10px;background-color:#ffffff;border:solid 1px #cccccc;"></td>'."\n";
    $html .= '<td><input type="button" name="bgcolor_body_btn" value="選択" onmousedown="ColorPickUp(\'bgcolor_body\');"></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '</table>'."\n";
    $html .= '</div>'."\n";
    $html .= '<span class="small">カラーピッカー（選択）が付属していますが、16進6桁手入力でもOKです。</span>'."\n";

    $html .= '</td>'."\n";
    $html .= '</tr>'."\n";

    $html .= '<tr>'."\n";
    $html .= '<th>※'.$forms['font_color']['name'].'</th>'."\n";
    $html .= '<td>'."\n";

    $html .= '<div class="border0">'."\n";
    $html .= '<table>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<td># <input type="text" name="font_color" value="'.showEscap($confs['font_color']).'" size="8" class="imeoff" onchange="ColorSet()"></td>'."\n";
    $html .= '<td><div id="sample_font_color" style="width:10px;height:10px;background-color:#ffffff;border:solid 1px #cccccc;"></td>'."\n";
    $html .= '<td><input type="button" name="font_color_btn" value="選択" onmousedown="ColorPickUp(\'font_color\');"></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '</table>'."\n";
    $html .= '</div>'."\n";
    $html .= '<span class="small">カラーピッカー（選択）が付属していますが、16進6桁手入力でもOKです。</span>'."\n";

    $html .= '</td>'."\n";
    $html .= '</tr>'."\n";

    $html .= '<tr>'."\n";
    $html .= '<th>※'.$forms['font_size']['name'].'</th>'."\n";
    $html .= '<td><input type="text" name="font_size" value="'.showEscap($confs['font_size']).'" size="3" class="imeoff"> px<br><span class="small">半角数字</span></td>'."\n";
    $html .= '</tr>'."\n";

    $html .= '<tr>'."\n";
    $html .= '<th>※'.$forms['font_size_title']['name'].'</th>'."\n";
    $html .= '<td><input type="text" name="font_size_title" value="'.showEscap($confs['font_size_title']).'" size="3" class="imeoff"> px<br><span class="small">半角数字</span></td>'."\n";
    $html .= '</tr>'."\n";

    $html .= '<tr>'."\n";
    $html .= '<th>※'.$forms['place']['name'].'</th>'."\n";
    $html .= '<td><input type="radio" name="place" value="0"'.$chk0.' id="chk0"><label for="chk0"> LEFT</label> <input type="radio" name="place" value="1"'.$chk1.' id="chk1"><label for="chk1"> CENTER</label><br><span class="small">「CENTER」を選択で中央に配置となります</span></td>'."\n";
    $html .= '</tr>'."\n";

    $html .= '<tr>'."\n";
    $html .= '<th>※'.$forms['width']['name'].'</th>'."\n";
    $html .= '<td><input type="text" name="width" value="'.showEscap($confs['width']).'" size="5" size="5" class="imeoff"> px<br><span class="small">半角数字</span></td>'."\n";
    $html .= '</tr>'."\n";

    $html .= '<tr>'."\n";
    $html .= '<th>※'.$forms['border_form']['name'].'</th>'."\n";
    $html .= '<td>'."\n";

    $html .= '<div class="border0">'."\n";
    $html .= '<table>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<td># <input type="text" name="border_form" value="'.showEscap($confs['border_form']).'" size="8" class="imeoff" onchange="ColorSet()"></td>'."\n";
    $html .= '<td><div id="sample_border_form" style="width:10px;height:10px;background-color:#ffffff;border:solid 1px #cccccc;"></td>'."\n";
    $html .= '<td><input type="button" name="border_form_btn" value="選択" onmousedown="ColorPickUp(\'border_form\');"></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '</table>'."\n";
    $html .= '</div>'."\n";
    $html .= '<span class="small">カラーピッカー（選択）が付属していますが、16進6桁手入力でもOKです。</span>'."\n";

    $html .= '</td>'."\n";
    $html .= '</tr>'."\n";

    $html .= '<tr>'."\n";
    $html .= '<th>※'.$forms['bgcolor_th']['name'].'</th>'."\n";
    $html .= '<td>'."\n";

    $html .= '<div class="border0">'."\n";
    $html .= '<table>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<td># <input type="text" name="bgcolor_th" value="'.showEscap($confs['bgcolor_th']).'" size="8" class="imeoff" onchange="ColorSet()"></td>'."\n";
    $html .= '<td><div id="sample_bgcolor_th" style="width:10px;height:10px;background-color:#ffffff;border:solid 1px #cccccc;"></td>'."\n";
    $html .= '<td><input type="button" name="bgcolor_th_btn" value="選択" onmousedown="ColorPickUp(\'bgcolor_th\');"></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '</table>'."\n";
    $html .= '</div>'."\n";
    $html .= '<span class="small">カラーピッカー（選択）が付属していますが、16進6桁手入力でもOKです。</span>'."\n";

    $html .= '</td>'."\n";
    $html .= '</tr>'."\n";

    $html .= '<tr>'."\n";
    $html .= '<th>※'.$forms['bgcolor_td']['name'].'</th>'."\n";
    $html .= '<td>'."\n";

    $html .= '<div class="border0">'."\n";
    $html .= '<table>'."\n";
    $html .= '<tr>'."\n";
    $html .= '<td># <input type="text" name="bgcolor_td" value="'.showEscap($confs['bgcolor_td']).'" size="8" class="imeoff" onchange="ColorSet()"></td>'."\n";
    $html .= '<td><div id="sample_bgcolor_td" style="width:10px;height:10px;background-color:#ffffff;border:solid 1px #cccccc;"></td>'."\n";
    $html .= '<td><input type="button" name="bgcolor_td_btn" value="選択" onmousedown="ColorPickUp(\'bgcolor_td\');"></td>'."\n";
    $html .= '</tr>'."\n";
    $html .= '</table>'."\n";
    $html .= '</div>'."\n";
    $html .= '<span class="small">カラーピッカー（選択）が付属していますが、16進6桁手入力でもOKです。</span>'."\n";

    $html .= '</td>'."\n";
    $html .= '</tr>'."\n";

    $html .= '</table>'."\n";
    $html .= '<br>'."\n";
    $html .= '<p class="center"><input type="submit" name="submit" value="設定する" class="btn_l"></p>'."\n";
    $html .= '<br>'."\n";
    $html .= '</div>'."\n";
    $html .= '<input type="hidden" name="md" value="editExec">'."\n";
    $html .= '</form>'."\n";

    $html .= '<hr size="1">'."\n";
    $html .= '<p>【現在の表示画面】</p>'."\n";
    $html .= '<iframe src="mail.php?pv=1" name="PV" width="600" height="500" frameborder="0">iframe対応のブラウザではここにプレビューが表示されます。</iframe>'."\n";
    return $html;
}
/**
*
* 編集実行
*
*/
function editExecAction($forms, $confs)
{
    // フォーム値チェック
    $errors = validate($forms);
    if ($errors) {
        return errorContentsAdmin($errors);
    }

    // 設定ファイル書き込み
    if (!confWrite(CONF_FILE, $forms)) {
        return errorContentsAdmin(array('設定ファイルの編集に失敗しました。'.CONF_FILE.'のパーミッションをご確認ください。'));
    } else {
        // セッションパスワード上書き
        $_SESSION['pass'] = $forms['pass']['value'];
        // 編集に戻す
        header('Location: admin.php?md=edit');
        return 'Error: Location Error';
    }
}
/**
*
* ログアウト
*
*/
function logoutAction()
{
    // パスワード消去
    $_SESSION['pass'] = '';
    // ログイン画面へ戻す
    header('Location: admin.php');
    return 'Error: Location Error';
}


/**
*
* エラー表示
*
*/
function errorContentsAdmin($errors)
{
    $html .= '<div class="error">'."\n";
    $html .= '<p>Error</p>'."\n";
    foreach ($errors as $error) {
        $html .= $error.'<br>'."\n";
    }
    $html .= '<br>'."\n";
    $html .= '<input type="button" value="戻る" class="btn_l" onclick="javascript:history.back();">'."\n";
    $html .= '</div>'."\n";
    return $html;
}


/**
*
* CSS
*
*/
function cssAdmin()
{
    $css = <<<CSS
body {
    font-size: 12px;
    color: #666666;
    text-align: center;
}
.contents {
    margin: 0px auto;
    text-align: left;
    width: 600px;
}
.contents h1 {
    text-align: center;
    font-size: 12px;
}
.contents table {
    font-size: 12px;
    border-collapse: collapse;
}
.contents textarea {
    font-size: 12px;
    width: 400px;
}
form {
    margin: 0px;
}
.small {
    font-size: 10px;
    color: #83adaf;
}
.btn_l {
    width: 120px;
}
.admin_t {
    width: 100%;
}
.admin_t table {
	width: 100%;
}
.admin_t th {
    width: 30%;
	font-weight: normal;
	background-color: #eef;
	padding: 4px;
	border: solid 1px #ccc;
	text-align: right;
}
.admin_t td {
    width: 70%;
	padding: 4px;
	border: solid 1px #ccc;
}
.border0 table {
    width: auto;
}
.border0 td {
    border: none;
    width: auto;
}
.right {
    text-align: right;
}
.center {
    text-align: center;
}
.attention {
    color: #f33;
}
.error {
    color: #f33;
}
.imeoff {
    ime-mode: disabled;
}

CSS;
    return $css;
}

/**
*
* JavaScript
*
*/
function jsAdmin()
{
    $js = <<<JS
<script type="text/javascript" language="JavaScript">
<!--
function ColorSet() {
	window.document.getElementById("sample_bgcolor_body").style.backgroundColor  = "#"+window.document.AdminForm.bgcolor_body.value;
	window.document.getElementById("sample_font_color").style.backgroundColor    = "#"+window.document.AdminForm.font_color.value;
	window.document.getElementById("sample_border_form").style.backgroundColor = "#"+window.document.AdminForm.border_form.value;
	window.document.getElementById("sample_bgcolor_th").style.backgroundColor   = "#"+window.document.AdminForm.bgcolor_th.value;
	window.document.getElementById("sample_bgcolor_td").style.backgroundColor   = "#"+window.document.AdminForm.bgcolor_td.value;
}
function ColorPickUp(name) {
	
	if(navigator.appName == "Microsoft Internet Explorer") {
		window.document.AdminForm.bgcolor_body_btn.onmouseup = GetXY_IE;
		window.document.AdminForm.font_color_btn.onmouseup = GetXY_IE;
		window.document.AdminForm.border_form_btn.onmouseup = GetXY_IE;
		window.document.AdminForm.bgcolor_th_btn.onmouseup = GetXY_IE;
		window.document.AdminForm.bgcolor_td_btn.onmouseup = GetXY_IE;
	}
	else {
		window.document.AdminForm.bgcolor_body_btn.onmouseup = GetXY_NotIE;
		window.document.AdminForm.font_color_btn.onmouseup = GetXY_NotIE;
		window.document.AdminForm.border_form_btn.onmouseup = GetXY_NotIE;
		window.document.AdminForm.bgcolor_th_btn.onmouseup = GetXY_NotIE;
		window.document.AdminForm.bgcolor_td_btn.onmouseup = GetXY_NotIE;
	}
	
	function GetXY_IE() {
		OpenWin_x = event.screenX;
		OpenWin_y = event.screenY;
		window.open("color.php?name="+name,"cpWin","resizable=yes,width=255,height=170,location=no,menubar=no,status=no,toolbar=no,left="+OpenWin_x+",top="+OpenWin_y);
	}
	
	function GetXY_NotIE(evt){
		OpenWin_x = evt.screenX;
		OpenWin_y = evt.screenY;
		window.open("color.php?name="+name,"cpWin","resizable=yes,width=255,height=170,location=no,menubar=no,status=no,toolbar=no,left="+OpenWin_x+",top="+OpenWin_y);
	}
}
setTimeout("ColorSet()",500);
//-->
</script>
JS;
    return $js;
}
